#include <oxstd.h>
#import <packages/PcGive/pcgive_ects>
#include <oxfloat.h>
// *Written by:* 		  Andr Anundsen
// *Purpose:*    		  This program uses several sub-routines to test the order of integration of the data series for the 100 MSAs included in the
//************//		  econometric analysis. The routine levels tests whether the levels are statinary, i.e. whether the series is I(0). The routine
//***********//           first_diff does the same for the first differences, i.e. testing whether the series are I(1), while the routine second_diff does
//**********//            so for the second differences, i.e. testing for signs of I(2). The results are saved in excel sheets in the routine save_output
// *Date of last update:* 14/08-2015

#include "defining_variables.ox"
#include "data.ox"
#include "levels.ox"
#include "first_diff.ox"
#include "second_diff.ox"
#include "save_output.ox"

main()
{
//oxprintlevel(0);
// *******************************************************************
//root = "YOUR LOCAL PATH"; ***
//********************************************************************

// Set sample and area
start_year     = 1970;
start_quarter  = 1;
end_year       = 2014;
end_quarter    = 4;
seasons        = FALSE;							   					
total_obs      = 180;
// Initial lag length
max_lag = 8;
// Critical value for Gets lag-selection part
t_crit_val = 1.96; 
// Helps to get the "correct" sample srtarting point, so that it is the same for all areas independent of the number of lags chosen 
N =  20;
variables = 17; 

firsters = 0;
lasters  = N - 1;
opt_lag = zeros(variables,1); 
// Loading in the data
data_loader();

// Testing for I(0), I(1) or I(2)
levels();
first_diff();
second_diff();


// Save the output in csv files
save_output();
//println("These are test statistics ");
//print(tval_level);
//println("And the order of integration is ");
//print(order_integration);
//println("And then the average order of integration is ");
//print(stationary);
//println("And average lag lengths are");
}






  